<?php

namespace App\Wrangler\Components;

use Illuminate\Http\Request;
use Medialight\Textstem\Models\WranglerPage;
use Medialight\Textstem\Wrangler\ActiveComponent;

/**
 * Class Sample
 *
 * A short summary of what this component does.
 *
 * @extends ActiveComponent
 */
class Goo extends ActiveComponent
{
    public static string $description = 'Warp an image with mouse over.';
    public static string $version = '1.0.0';

    public $config;

    public array $editSetup = [
        [
            'name' => 'template',
            'controltype' => 'select-template',
            'value' => 'default',
        ],
        [
            'name' => 'title',
            'controltype' => 'text',
            'value' => '',
            'label' => 'Title',
        ],
        [
            'name' => 'content',
            'controltype' => 'asset_selector',
            'type' => 'image',
            'value' => '',
            'label' => 'Image',
        ],
        [
            'name' => 'radius',
            'controltype' => 'number',
            'value' => 140,
            'label' => 'Radius',
            'instructions' => 'Scale displacement sprite to roughly match desired radius',
            'size' => 1,
        ],
        [
            'name' => 'intensity',
            'controltype' => 'number    ',
            'value' => 60,
            'label' => 'Intensity',
            'instructions' => 'How strongly the displacement effect warps the image',
            'size' => 1,
        ],
    ];

    public function render(Request $request, WranglerPage $wranglerPage)
    {

        $view = $this->getView();
        $data = $this->data();
        $data['page'] = $wranglerPage;

        // add any extra stuff the view needs to $data
        return view($view, $data)->render();
    }

    public function preview()
    {
        $view = $this->getPreview();
        $data = $this->data();
        return view($view, $data)->render();
    }
}
