@if($content ?? '')
    <div class="goo relative inline-block select-none" data-radius="{{$radius ?? 140}}"
         data-intensity="{{$intensity ?? 60}}">
        <!-- The <img> gives us natural sizing and aspect; PIXI will overlay it -->
        <img src="{{ Storage::url($content) }}" class="block w-full h-auto" alt="Goo Image"/>

        <!-- PIXI canvas will be injected here -->
        <div class="goo-stage absolute inset-0"></div>
    </div>


    @if($page->gooAdded ?? false)
        <!-- goo already added -->
    @else
        <!-- PixiJS (renderer and filtering) and GSAP (animation) -->

        <script src="https://cdnjs.cloudflare.com/ajax/libs/pixi.js/7.4.0/pixi.min.js"
                    crossorigin="anonymous"
                    referrerpolicy="no-referrer"></script>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"
                    crossorigin="anonymous"
                    crossorigin="anonymous"
                    referrerpolicy="no-referrer"></script>

            <script>
                (function () {
                    function initGoo(container) {
                        var img = container.querySelector('img');

                        var stageHost = container.querySelector('.goo-stage');
                        // GSAP is optional; we'll fall back to direct property updates if it's not present
                        if (!img || !stageHost || !window.PIXI) {
                            return;
                        }

                        var radius = parseFloat(container.getAttribute('data-radius') || '140');
                        var intensity = parseFloat(container.getAttribute('data-intensity') || '60');

                        // Destroy any prior instance if re-initializing (e.g., hot reload)
                        if (stageHost.__goo) {
                            try {
                                stageHost.__goo.app.destroy(true, {children: true, texture: true, baseTexture: true});
                            } catch (e) {
                            }
                            stageHost.__goo = null;
                            stageHost.innerHTML = '';
                        }

                        // Create PIXI app that resizes to the stageHost
                        var app = new PIXI.Application({
                            backgroundAlpha: 0,
                            antialias: true,
                            resolution: window.devicePixelRatio || 1,
                            autoDensity: true,
                            resizeTo: stageHost
                        });
                        stageHost.appendChild(app.view);

                        // Base image sprite
                        var baseSprite = null;
                        // Displacement sprite + filter
                        var dispSprite = null;
                        var dispFilter = null;

                        function makeRadialDisplacementTexture(size) {
                            size = size || 256;
                            var c = document.createElement('canvas');
                            c.width = c.height = size;
                            var ctx = c.getContext('2d');
                            var g = ctx.createRadialGradient(size / 2, size / 2, 0, size / 2, size / 2, size / 2);
                            // White center (255) to black edges (0). Values are read relative to 128 by the filter.
                            g.addColorStop(0, 'rgb(255,255,255)');
                            g.addColorStop(1, 'rgb(0,0,0)');
                            ctx.fillStyle = g;
                            ctx.fillRect(0, 0, size, size);
                            return PIXI.Texture.from(c);
                        }

                        function build() {
                            app.stage.removeChildren();

                            var w = stageHost.clientWidth;
                            var h = stageHost.clientHeight;
                            if (w === 0 || h === 0) {
                                return;
                            }

                            // Create the base sprite from the <img>
                            var baseTex = PIXI.Texture.from(img.src);
                            baseSprite = new PIXI.Sprite(baseTex);
                            baseSprite.x = 0;
                            baseSprite.y = 0;
                            baseSprite.width = w;
                            baseSprite.height = h;
                            app.stage.addChild(baseSprite);

                            // Create displacement sprite and filter
                            var dispTex = makeRadialDisplacementTexture(Math.max(128, Math.round(Math.min(w, h) * 0.6)));
                            dispSprite = new PIXI.Sprite(dispTex);
                            dispSprite.anchor.set(0.5);
                            dispSprite.x = w * 0.5;
                            dispSprite.y = h * 0.5;
                            // Scale displacement sprite to roughly match desired radius
                            var scaleFactor = (radius * 2) / dispTex.width; // width == height
                            dispSprite.scale.set(scaleFactor);
                            app.stage.addChild(dispSprite);

                            dispFilter = new PIXI.filters.DisplacementFilter(dispSprite);
                            dispFilter.padding = Math.ceil(radius + intensity);
                            dispFilter.scale.x = 0; // start inactive
                            dispFilter.scale.y = 0;

                            baseSprite.filters = [dispFilter];
                        }

                        function onMouseMove(e) {
                            var rect = stageHost.getBoundingClientRect();
                            var mx = e.clientX - rect.left;
                            var my = e.clientY - rect.top;

                            if (!dispSprite || !dispFilter) {
                                return;
                            }
                            // Move displacement sprite to cursor; use GSAP if present, otherwise set directly
                            if (window.gsap) {
                                gsap.to(dispSprite, {
                                    x: mx,
                                    y: my,
                                    duration: 0.12,
                                    ease: 'power2.out',
                                    overwrite: 'auto'
                                });
                                gsap.to(dispFilter.scale, {
                                    x: intensity,
                                    y: intensity,
                                    duration: 0.18,
                                    ease: 'power2.out',
                                    overwrite: 'auto'
                                });
                            } else {
                                dispSprite.x = mx;
                                dispSprite.y = my;
                                dispFilter.scale.x = intensity;
                                dispFilter.scale.y = intensity;
                            }
                        }

                        function onMouseLeave() {
                            if (!dispSprite || !dispFilter) {
                                return;
                            }
                            // Ease the displacement to zero; GSAP optional
                            if (window.gsap) {
                                gsap.to(dispFilter.scale, {
                                    x: 0,
                                    y: 0,
                                    duration: 0.35,
                                    ease: 'power2.out',
                                    overwrite: 'auto'
                                });
                            } else {
                                dispFilter.scale.x = 0;
                                dispFilter.scale.y = 0;
                            }
                        }

                        function onResize() {
                            build();
                        }

                        // Build once image has natural size available
                        function ready() {
                            build();
                        }

                        if (img.complete) {
                            ready();
                        } else {
                            img.addEventListener('load', ready, {once: true});
                        }

                        // Listeners
                        container.addEventListener('mousemove', onMouseMove);
                        container.addEventListener('mouseleave', onMouseLeave);
                        window.addEventListener('resize', onResize);

                        // Save instance for cleanup
                        stageHost.__goo = {app: app};
                    }

                    document.addEventListener('DOMContentLoaded', function () {
                        document.querySelectorAll('.goo').forEach(initGoo);
                    });
                })();
            </script>

        @php($page->gooAdded = true)
    @endif
@else
    <!-- no image selected for goo -->
@endif
